import pandas as pd
import numpy as np
import pickle
from decision_company import read_csv_file, access_dataframe_loc, get_max, assert_series, is_a_null_df, visit_by_index


atp_tennis = read_csv_file('atp_tennis.csv')

def update_odds(match_id, performance_weight, h2h_weight, data, h2h_win_rates):
    player_1 = access_dataframe_loc(data, match_id, 'Player_1')
    player_2 = access_dataframe_loc(data, match_id, 'Player_2')

    player_1_win_rate = access_dataframe_loc(player_stats, assert_series(player_stats['Opponent'], player_1, 'equality'), 'Win Rate')
    player_2_win_rate = access_dataframe_loc(player_stats, assert_series(player_stats['Opponent'], player_2, 'equality'), 'Win Rate')

    player_1_win_rate = visit_by_index(player_1_win_rate, 0) if not is_a_null_df(player_1_win_rate) else 0
    player_2_win_rate = visit_by_index(player_2_win_rate, 0) if not is_a_null_df(player_2_win_rate) else 0

    h2h_player_1_win_rate = access_dataframe_loc(h2h_win_rates, assert_series(h2h_win_rates['Opponent'], player_2, 'equality'), 'Head-to-Head Win Rate')
    h2h_player_2_win_rate = access_dataframe_loc(h2h_win_rates, assert_series(h2h_win_rates['Opponent'], player_1, 'equality'), 'Head-to-Head Win Rate')

    h2h_player_1_win_rate = visit_by_index(h2h_player_1_win_rate, 0) if not is_a_null_df(h2h_player_1_win_rate) else 0
    h2h_player_2_win_rate = visit_by_index(h2h_player_2_win_rate, 0) if not is_a_null_df(h2h_player_2_win_rate) else 0

    player_1_probability, player_2_probability = estimate_probability(player_1_win_rate, player_2_win_rate, h2h_player_1_win_rate, h2h_player_2_win_rate, performance_weight, h2h_weight)
    max_odd_1 = get_max(data['Odd_1'])
    max_odd_2 = get_max(data['Odd_2'])

    if player_1_probability == 0:
        updated_odd_1 = max_odd_1
    else:
        updated_odd_1 = 1 / player_1_probability

    if player_2_probability == 0:
        updated_odd_2 = max_odd_2
    else:
        updated_odd_2 = 1 / player_2_probability

    return updated_odd_1, updated_odd_2